/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.JpegStartOfFrameDirectory;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.metadata.Directory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartOfFrameSegmentReader
implements JpegSegmentReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$read$StartOfFrameSegmentReader == null ? (class$au$com$lastweekend$jim$io$jpeg$read$StartOfFrameSegmentReader = StartOfFrameSegmentReader.class$("au.com.lastweekend.jim.io.jpeg.read.StartOfFrameSegmentReader")) : class$au$com$lastweekend$jim$io$jpeg$read$StartOfFrameSegmentReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$read$StartOfFrameSegmentReader;

    public Directory extractDirectory(JpegSegment segment) throws JpegProcessingException {
        JpegStartOfFrameDirectory directory = new JpegStartOfFrameDirectory(segment);
        byte framePrecision = segment.get8Bits(0);
        int frameHeight = segment.get16Bits(1);
        int frameWidth = segment.get16Bits(3);
        int components = segment.get8Bits(5);
        directory.setValue(1, framePrecision);
        directory.setValue(3, frameHeight);
        directory.setValue(2, frameWidth);
        directory.setValue(4, (byte)components);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SOF: id=" + Integer.toHexString(segment.getIdentifier()) + " p=" + framePrecision + " h=" + frameHeight + " w=" + frameWidth + " c=" + components));
        }
        byte[] componentID = new byte[components];
        byte[] verticalSamplingFactors = new byte[components];
        byte[] horizontalSamplingFactors = new byte[components];
        byte[] quantisationTable = new byte[components];
        for (int i = 0; i < components; ++i) {
            int offset = 6 + i * 3;
            componentID[i] = segment.get8Bits(offset);
            horizontalSamplingFactors[i] = segment.getHigh4Bits(offset + 1);
            verticalSamplingFactors[i] = segment.getLow4Bits(offset + 1);
            quantisationTable[i] = segment.get8Bits(offset + 2);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("SOF c[" + componentID[i] + "] vF=" + verticalSamplingFactors[i] + " hF=" + horizontalSamplingFactors[i] + " qT=" + quantisationTable[i]));
        }
        directory.setValue(5, componentID);
        directory.setValue(6, verticalSamplingFactors);
        directory.setValue(7, horizontalSamplingFactors);
        directory.setValue(8, quantisationTable);
        return directory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

