/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.write;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegQuantisationTableDirectory;
import au.com.lastweekend.jim.io.jpeg.write.AbstractSegmentDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegTransform;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import java.io.IOException;
import java.io.OutputStream;

public class QuantisationTableSegmentWriter
extends AbstractSegmentDirectoryWriter {
    private JpegTransform _transform;

    public QuantisationTableSegmentWriter(JpegTransform transform) {
        this._transform = transform;
    }

    public QuantisationTableSegmentWriter() {
        this(JpegTransform.NO_TRANSFORM);
    }

    public void writeDirectory(Directory directory, OutputStream output) throws JpegProcessingException {
        if (directory.isRootDirectory()) {
            this.writeQuantisationTableDirectory((JpegQuantisationTableDirectory)directory, output);
        }
    }

    private void writeQuantisationTableDirectory(JpegQuantisationTableDirectory directory, OutputStream output) throws JpegProcessingException {
        try {
            int segmentLength = this.getSegmentLength(directory);
            this.writeHeader((byte)-37, segmentLength, output);
            do {
                byte precision = directory.getPrecision();
                byte tableID = directory.getTableID();
                byte[] elements = directory.getElements();
                int compressedPqTq = (precision << 4) + tableID & 0xFF;
                output.write(compressedPqTq);
                for (int i = 0; i < elements.length; ++i) {
                    int k = this._transform.transformZZIndex(i);
                    output.write(elements[k]);
                }
            } while ((directory = (JpegQuantisationTableDirectory)directory.getLinkedDirectory()) != null);
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
        catch (MetadataException e) {
            throw new JpegProcessingException(e);
        }
    }

    private int getSegmentLength(JpegQuantisationTableDirectory directory) {
        int segmentLength = 2;
        do {
            segmentLength += 65;
        } while ((directory = (JpegQuantisationTableDirectory)directory.getLinkedDirectory()) != null);
        return segmentLength;
    }
}

