/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.metadata;

import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.Tag;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;
import au.com.lastweekend.jim.util.Rational;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class Directory
implements Serializable {
    private Directory _linkedDirectory;
    private Directory _parentDirectory;
    private final HashMap _tagMap;
    private TagDescriptor _descriptor;
    private final List _definedTagList;
    private List _errorList;
    private List _subDirectories = new ArrayList();

    public abstract String getName();

    protected abstract HashMap getTagNameMap();

    public Directory(Directory parent) {
        this._tagMap = new LinkedHashMap();
        this._definedTagList = new ArrayList();
        this._errorList = new ArrayList();
        this._parentDirectory = parent;
    }

    public boolean isRootDirectory() {
        return this._parentDirectory == null;
    }

    public boolean containsTag(int tagType) {
        return this._tagMap.containsKey(new Integer(tagType));
    }

    public Iterator getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = descriptor;
    }

    public void addError(String message) {
        if (this._errorList == null) {
            this._errorList = new ArrayList();
        }
        this._errorList.add(message);
    }

    public boolean hasErrors() {
        return this._errorList != null && this._errorList.size() > 0;
    }

    public Iterator getErrors() {
        return this._errorList.iterator();
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setTag(int tagType, int formatCode, Object value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null object");
        }
        Integer key = new Integer(tagType);
        if (!this._tagMap.containsKey(key)) {
            this._definedTagList.add(new Tag(tagType, formatCode, this));
        }
        this._tagMap.put(key, value);
    }

    public void removeTag(int tagType) {
        this._tagMap.remove(new Integer(tagType));
        Iterator iter = this._definedTagList.iterator();
        while (iter.hasNext()) {
            Tag currentTag = (Tag)iter.next();
            if (currentTag.getTagType() != tagType) continue;
            iter.remove();
        }
    }

    public int getInt(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException nfe) {
                String s = (String)o;
                int val = 0;
                for (int i = s.length() - 1; i >= 0; --i) {
                    val += s.charAt(i) << i * 8;
                }
                return val;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new MetadataException("Requested tag cannot be cast to int");
    }

    public double getDouble(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a double", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new MetadataException("Requested tag cannot be cast to double");
    }

    public float getFloat(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a float", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new MetadataException("Requested tag cannot be cast to float");
    }

    public long getLong(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a long", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new MetadataException("Requested tag cannot be cast to long");
    }

    public boolean getBoolean(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.getBoolean((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a boolean", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        throw new MetadataException("Requested tag cannot be cast to boolean");
    }

    public Date getDate(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            String[] datePatterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String dateString = (String)o;
            for (int i = 0; i < datePatterns.length; ++i) {
                try {
                    SimpleDateFormat parser = new SimpleDateFormat(datePatterns[i]);
                    return parser.parse(dateString);
                }
                catch (ParseException ex) {
                    continue;
                }
            }
        }
        throw new MetadataException("Requested tag cannot be cast to java.util.Date");
    }

    public String[] getStringArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            String[] strings = new String[]{(String)o};
            return strings;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            String[] strings = new String[ints.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Integer.toString(ints[i]);
            }
            return strings;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            String[] strings = new String[bytes.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Byte.toString(bytes[i]);
            }
            return strings;
        }
        throw new MetadataException("Requested tag cannot be cast to String array (" + o.getClass().toString() + ")");
    }

    public int[] getIntArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            int[] ints = new int[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                int b;
                ints[i] = b = bytes[i];
            }
            return ints;
        }
        if (o instanceof String) {
            String str = (String)o;
            int[] ints = new int[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                ints[i] = str.charAt(i);
            }
            return ints;
        }
        throw new MetadataException("Requested tag cannot be cast to int array (" + o.getClass().toString() + ")");
    }

    public Rational[] getRationalArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Requested tag cannot be cast to Rational array (" + o.getClass().toString() + ")");
    }

    public byte[] getByteArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            byte[] bytes = new byte[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                bytes[i] = (byte)ints[i];
            }
            return bytes;
        }
        if (o instanceof String) {
            String str = (String)o;
            byte[] bytes = new byte[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                bytes[i] = (byte)str.charAt(i);
            }
            return bytes;
        }
        throw new MetadataException("Requested tag cannot be cast to byte array (" + o.getClass().toString() + ")");
    }

    public Rational getRational(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational) {
            return (Rational)o;
        }
        throw new MetadataException("Requested tag cannot be cast to Rational");
    }

    public String getString(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational) {
            return ((Rational)o).toSimpleString(true);
        }
        if (o.getClass().isArray()) {
            int arrayLength = Array.getLength(o);
            boolean isObjectArray = o.getClass().toString().startsWith("class [L");
            StringBuffer sbuffer = new StringBuffer();
            for (int i = 0; i < arrayLength; ++i) {
                if (i != 0) {
                    sbuffer.append(' ');
                }
                if (isObjectArray) {
                    sbuffer.append(Array.get(o, i).toString());
                    continue;
                }
                sbuffer.append(Array.getInt(o, i));
            }
            return sbuffer.toString();
        }
        return o.toString();
    }

    public Object getObject(int tagType) {
        return this._tagMap.get(new Integer(tagType));
    }

    public String getTagName(int tagType) {
        Integer key = new Integer(tagType);
        HashMap nameMap = this.getTagNameMap();
        if (!nameMap.containsKey(key)) {
            String hex = Integer.toHexString(tagType);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            return "Unknown tag (0x" + hex + ")";
        }
        return (String)nameMap.get(key);
    }

    public String getDescription(int tagType) throws MetadataException {
        if (this._descriptor == null) {
            throw new MetadataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(tagType);
    }

    public void addSubDirectory(int tagType, int formatCode, Directory subDirectory) {
        this._subDirectories.add(subDirectory);
        this.setTag(tagType, formatCode, subDirectory);
    }

    public void addLinkedDirectory(Directory linkedDirectory) throws MetadataException {
        if (this._linkedDirectory != null) {
            throw new MetadataException("Not expecting more than one linked directory");
        }
        this._linkedDirectory = linkedDirectory;
    }

    public Directory getLinkedDirectory() {
        return this._linkedDirectory;
    }

    public List getSubDirectories() {
        return this._subDirectories;
    }

    public Directory getParentDirectory() {
        return this._parentDirectory;
    }

    protected List getDefinedTagList() {
        return this._definedTagList;
    }

    protected HashMap getTagMap() {
        return this._tagMap;
    }

    protected TagDescriptor getDescriptor() {
        return this._descriptor;
    }

    public boolean hasLinkedDirectory() {
        return this._linkedDirectory != null;
    }

    public boolean isTagUpdateable(int tagType) {
        if (this._descriptor != null) {
            return this._descriptor.isTagUpdateable(tagType);
        }
        return false;
    }
}

