/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.metadata;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import java.io.Serializable;

public class Tag
implements Serializable {
    private final int _tagType;
    private final int _formatCode;
    private final Directory _directory;

    public Tag(int tagType, int formatCode, Directory directory) {
        this._tagType = tagType;
        this._directory = directory;
        this._formatCode = formatCode;
    }

    public int getTagType() {
        return this._tagType;
    }

    public String getTagTypeHex() {
        String hex = Integer.toHexString(this._tagType);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "0x" + hex;
    }

    public String getDescription() throws MetadataException {
        return this._directory.getDescription(this._tagType);
    }

    public String getTagName() {
        return this._directory.getTagName(this._tagType);
    }

    public String getDirectoryName() {
        return this._directory.getName();
    }

    public String toString() {
        String description;
        try {
            description = this.getDescription();
        }
        catch (MetadataException e) {
            description = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "] " + this.getTagName() + " - " + description;
    }

    public int getFormatCode() {
        return this._formatCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tag) {
            Tag other = (Tag)obj;
            return this._tagType == other._tagType && this._formatCode == other._formatCode;
        }
        return false;
    }

    public int hashCode() {
        return this._tagType & this._formatCode;
    }

    public boolean isUpdateable() {
        return this._directory.isTagUpdateable(this._tagType);
    }

    public void update(Object value) {
        this._directory.setTag(this._tagType, this._formatCode, value);
    }
}

