/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.zooomr.Messages;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi;
import org.scohen.juploadr.uploadapi.zooomr.photosets.AddPhoto;

public class AddToPhotosetTask
extends Task {
    private Collection sets;
    private ZooomrRestApi api;
    private int numberOfSets;
    private boolean hasSetsToAdd;
    private String currentPhoto;
    private String currentSet;
    private int current = 0;

    public AddToPhotosetTask(Collection photoSets, ZooomrRestApi api) {
        this.sets = photoSets;
        this.api = api;
        this.min = 0;
        this.max = this.getTotalNumberOfPhotosToAdd(photoSets);
        this.hasSetsToAdd = this.max != 0;
    }

    public String getTitle() {
        return Messages.getString("juploadr.zooomr.task.addtophotoset.adding") + this.max + Messages.getString("juploadr.flickrrest.task.addtophotoset.photos");
    }

    public void execute() {
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            this.currentSet = set.getTitle();
            List photos = set.getPhotos();
            Iterator photoIter = photos.iterator();
            while (photoIter.hasNext()) {
                AddPhoto add;
                ImageAttributes thumb = (ImageAttributes)photoIter.next();
                this.currentPhoto = thumb.getTitle();
                this.updateProgress(++this.current);
                if (!thumb.getPhotoId().equals(set.getPrimaryPhotoId()) && !this.api.executeMethod(add = new AddPhoto(set, (UploadImage)thumb))) continue;
            }
        }
    }

    private int getTotalNumberOfPhotosToAdd(Collection sets) {
        Iterator iter = sets.iterator();
        int count = 0;
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            if (set.getPhotos().size() <= 0) continue;
            ++this.numberOfSets;
            count += set.getPhotos().size();
        }
        return count;
    }

    public String getMessage() {
        return this.max - this.current + 1 + Messages.getString("juploadr.zooomr.task.addtophotoset.photostoaddto") + this.numberOfSets + Messages.getString("juploadr.zooomr.task.addtophotoset.sets") + Messages.getString("juploadr.flickrrest.task.addtophotoset.photosets") + Messages.getString("juploadr.flickrrest.task.addtophotoset.adding") + this.currentPhoto + Messages.getString("juploadr.zooomr.task.addtophotoset.to") + this.currentSet;
    }

    public boolean hasSetsToAdd() {
        return this.hasSetsToAdd;
    }
}

