/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.upload.HttpClientFactory;
import org.scohen.juploadr.uploadapi.Action;
import org.scohen.juploadr.uploadapi.AuthException;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.zooomr.DefaultZooomrHandler;
import org.scohen.juploadr.uploadapi.zooomr.StringSigner;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi;
import org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAccount;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ZooomrMethod
implements Action {
    protected static final String URL = "http://beta.zooomr.com/bluenote/api/rest";
    protected HttpClient client = HttpClientFactory.getHttpClient();
    private URLCodec codec = new URLCodec();
    private DefaultZooomrHandler handler;

    public abstract DefaultZooomrHandler getResponseHandler();

    public boolean execute() throws ProtocolException, CommunicationException {
        boolean rv;
        block7: {
            HttpMethodBase method = this.getMethod();
            rv = false;
            try {
                int response = this.client.executeMethod((HttpMethod)method);
                if (200 == response) {
                    rv = this.parseResponse(method.getResponseBodyAsString());
                    break block7;
                }
                Object[] args = new Object[]{new Integer(response)};
                throw new CommunicationException(Messages.getString((String)"juploadr.ui.error.bad.http.response", (Object[])args));
            }
            catch (HttpException e) {
                throw new CommunicationException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new CommunicationException(e.getMessage(), (Throwable)e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return rv;
    }

    public int getErrorCode() {
        return this.handler.getErrorCode();
    }

    public boolean parseResponse(String response) throws ProtocolException {
        try {
            System.setProperty("org.xml.sax.driver", "com.bluecast.xml.Piccolo");
            System.out.println(response);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            this.handler = this.getResponseHandler();
            reader.setContentHandler(this.handler);
            reader.parse(new InputSource(new StringReader(response)));
            if (!this.handler.isSuccessful()) {
                throw new ProtocolException(this.handler.getFailureReason());
            }
            return this.handler.isSuccessful();
        }
        catch (SAXException e) {
            throw new AuthException(Messages.getString((String)"juploadr.ui.error.response.unreadable.noreason"), (Exception)e);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public final String getSignature() {
        StringBuffer sb = new StringBuffer("fb2377b77bd2639c");
        SortedMap params = this.getParams();
        if (this.isAuthorized()) {
            ZooomrAccount currentAccount = (ZooomrAccount)ZooomrRestApi.getInstance().getCurrentAccount();
            params.put("auth_token", currentAccount.getToken());
        }
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String paramName = (String)iter.next();
            sb.append(paramName);
            sb.append((String)params.get(paramName));
        }
        return StringSigner.md5(sb.toString());
    }

    public String getQueryString(boolean signed) {
        StringBuffer queryString = new StringBuffer();
        SortedMap params = this.getParams();
        if (this.isAuthorized()) {
            params.put("auth_token", ((ZooomrAccount)ZooomrRestApi.getInstance().getCurrentAccount()).getToken());
        }
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String paramName = (String)iter.next();
            this.appendNVP(queryString, paramName, (String)params.get(paramName));
        }
        if (signed) {
            this.appendNVP(queryString, "api_sig", this.getSignature());
        }
        return queryString.toString();
    }

    private void appendNVP(StringBuffer url, String name, String value) {
        char lastChar;
        if (url.length() == 0) {
            url.append("?");
        }
        if ((lastChar = url.charAt(url.length() - 1)) != '&' && lastChar != '?') {
            url.append("&");
        }
        url.append(name);
        url.append("=");
        url.append(this.encode(value));
    }

    protected String encode(String toEnc) {
        try {
            return this.codec.encode(toEnc);
        }
        catch (EncoderException encoderException) {
            return null;
        }
    }

    public abstract SortedMap getParams();

    public abstract boolean isAuthorized();

    public HttpMethodBase getMethod() {
        StringBuffer query = new StringBuffer(URL);
        query.append(this.getQueryString(true));
        GetMethod get = new GetMethod(query.toString());
        return get;
    }
}

