/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr.photosets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scohen.juploadr.uploadapi.zooomr.DefaultZooomrHandler;
import org.scohen.juploadr.uploadapi.zooomr.photosets.ZooomrPhotoSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GetPhotosetListHandler
extends DefaultZooomrHandler {
    private ZooomrPhotoSet photoSet;
    private List photoSets = new ArrayList();

    public GetPhotosetListHandler(Object parent) {
        super(parent);
    }

    public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qname, atts);
        if ("photoset".equals(qname)) {
            if (this.photoSet != null) {
                this.photoSets.add(this.photoSet);
            }
            this.photoSet = new ZooomrPhotoSet();
            this.photoSet.setId(atts.getValue("id"));
            this.photoSet.setPrimaryPhotoId(atts.getValue("primary"));
            this.photoSet.setNumberOfPhotos(Integer.parseInt(atts.getValue("photos")));
            this.photoSet.setSecret(atts.getValue("secret"));
            this.photoSet.setServer(atts.getValue("server"));
        }
    }

    public void characters(char[] chars, int start, int end) throws SAXException {
        super.characters(chars, start, end);
        String cdata = new String(chars, start, end).trim();
        if (cdata.length() > 0) {
            if ("title".equals(this.lastTag)) {
                this.photoSet.setTitle(cdata);
            } else if ("description".equals(this.lastTag)) {
                this.photoSet.setDescription(cdata);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.photoSet != null) {
            this.photoSets.add(this.photoSet);
        }
    }

    public List getPhotoSets() {
        ZooomrPhotoSet ps = new ZooomrPhotoSet();
        Collections.sort(this.photoSets, new ZooomrPhotoSet.TitleComparator(ps));
        return this.photoSets;
    }
}

