/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest;

import java.util.Collection;
import java.util.Iterator;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.transform.Rotate;

public class RotateTask
extends Task {
    private Collection images;
    private RestFlickrApi api;
    private String photoName;
    private int cur;

    public RotateTask(Collection images, RestFlickrApi api) {
        this.min = 0;
        this.max = images.size();
        this.images = images;
        this.api = api;
    }

    public String getTitle() {
        Object[] args = new Object[]{new Integer(this.max)};
        return Messages.getString((String)"juploadr.ui.task.rotate.rotating.title", (Object[])args);
    }

    public void execute() {
        Iterator iter = this.images.iterator();
        while (iter.hasNext()) {
            UploadImage image = (UploadImage)iter.next();
            this.photoName = image.getTitle();
            this.updateProgress(++this.cur);
            Rotate rotate = new Rotate(image);
            this.api.executeMethod(rotate);
        }
    }

    public String getMessage() {
        Object[] args = new Object[]{this.photoName, new Integer(this.cur), new Integer(this.max)};
        return Messages.getString((String)"juploadr.ui.task.rotate.rotating", (Object[])args);
    }
}

