/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.authentication;

import java.io.IOException;
import java.io.StringReader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.uploadapi.AuthException;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.flickrrest.DefaultFlickrHandler;
import org.scohen.juploadr.uploadapi.flickrrest.FlickrMethod;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.FlickrAuthHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FlickrAuth
extends FlickrMethod {
    private String url = "http://www.flickr.com/tools/auth.gne";
    private String username;
    private String password;
    private boolean isPro = false;
    private long monthlyUploadLimit;
    private long currentUploadUsed;
    private String failureReason;
    private boolean successful = true;

    public FlickrAuth(String username, String password, HttpClient client) {
        this.username = username;
        this.password = password;
    }

    public boolean parseResponse(String response) throws ProtocolException {
        try {
            System.setProperty("org.xml.sax.driver", "com.bluecast.xml.Piccolo");
            XMLReader reader = XMLReaderFactory.createXMLReader();
            FlickrAuthHandler handler = new FlickrAuthHandler(this);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(response)));
            if (!this.isSuccessful()) {
                throw new AuthException(Messages.getString((String)"juploadr.ui.error.auth.failed") + this.getFailureReason());
            }
            return this.isSuccessful();
        }
        catch (SAXException e) {
            throw new AuthException(Messages.getString((String)"juploadr.ui.error.response.unreadable.noreason"), (Exception)e);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isPro() {
        return this.isPro;
    }

    public void setPro(boolean isPro) {
        this.isPro = isPro;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getCurrentUploadUsed() {
        return this.currentUploadUsed;
    }

    public void setCurrentUploadUsed(long currentUploadUsed) {
        this.currentUploadUsed = currentUploadUsed;
    }

    public long getMonthlyUploadLimit() {
        return this.monthlyUploadLimit;
    }

    public void setMonthlyUploadLimit(long monthlyUploadLimit) {
        this.monthlyUploadLimit = monthlyUploadLimit;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        this.successful = false;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean succeeded) {
        this.successful = succeeded;
    }

    public DefaultFlickrHandler getResponseHandler() {
        return new FlickrAuthHandler(this);
    }

    public HttpMethodBase getMethod() {
        PostMethod post = new PostMethod(this.url);
        post.addParameter(new NameValuePair("email", this.username));
        post.addParameter(new NameValuePair("password", this.password));
        return post;
    }

    public SortedMap getParams() {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("email", this.username);
        params.put("password", this.password);
        return params;
    }

    public boolean isAuthorized() {
        return false;
    }
}

