/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.ImageAttributesUI;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.app.tags.Tag;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.ui.MultiSelectThumbnail;
import org.scohen.juploadr.ui.ReusableUIFactory;

public class MultiImageAttributesUI
extends ImageAttributesUI {
    private List thumbnails;
    private MultiSelectThumbnail th;

    public MultiImageAttributesUI(List atts) {
        super((ImageAttributes)atts.get(0));
        this.thumbnails = atts;
    }

    protected void addThumbnails(Composite thumbnailComposite) {
        this.window.setText(Messages.getString("juploadr.ui.multiimageattributes.dialog.title") + this.thumbnails.size() + Messages.getString("juploadr.ui.multiimageattributes.dialog.title.suffix"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        thumbnailComposite.setLayout((Layout)layout);
        this.th = new MultiSelectThumbnail(thumbnailComposite, this.thumbnails);
        thumbnailComposite.setSize(-1, -1);
    }

    protected void gatherData() {
        String title = this.txtTitle.getText();
        String description = this.txtDescription.getText();
        String tags = this.txtTags.getText();
        boolean isPublic = this.radioPublic.getSelection();
        boolean isPrivate = this.radioPrivate.getSelection();
        boolean family = this.checkFamily.getSelection();
        boolean friends = this.checkFriends.getSelection();
        Iterator iter = this.thumbnails.iterator();
        while (iter.hasNext()) {
            ImageAttributes attrs = (ImageAttributes)iter.next();
            if (this.notEmpty(title)) {
                attrs.setTitle(title);
            }
            if (this.notEmpty(description)) {
                StringBuffer sb = new StringBuffer(this.getNonNullString(attrs.getDescription()));
                sb.append(" ");
                sb.append(this.getNonNullString(description));
                attrs.setDescription(sb.toString().trim());
            }
            if (this.notEmpty(tags)) {
                List oldTags = attrs.getTags();
                List newTags = TagParser.parse(tags);
                Iterator newTagIter = newTags.iterator();
                while (newTagIter.hasNext()) {
                    Tag tag = (Tag)newTagIter.next();
                    if (oldTags.contains(tag)) continue;
                    oldTags.add(tag);
                }
            }
            if (isPublic) {
                attrs.setPubliclyVisible(true);
            } else if (isPrivate) {
                attrs.setPubliclyVisible(false);
                attrs.setFamilyViewable(family);
                attrs.setFriendViewable(friends);
            }
            attrs.getButton().redraw();
        }
    }

    private boolean notEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected void initDefaultValues() {
        UploadImage initial = (UploadImage)this.thumbnails.get(0);
        this.radioPrivate.setSelection(!initial.isPubliclyVisible());
        this.radioPublic.setSelection(initial.isPubliclyVisible());
        this.checkFamily.setSelection(initial.isFamilyViewable());
        this.checkFriends.setSelection(initial.isFriendViewable());
        this.txtDescription.setText(this.getNonNullString(initial.getDescription()));
        this.txtTags.setText(this.getNonNullString(TagParser.toInputString(initial.getTags())));
        this.txtTitle.setText(this.getNonNullString(initial.getTitle()));
        boolean shouldCheckFriends = initial.isFriendViewable();
        boolean shouldCheckFamily = initial.isFamilyViewable();
        boolean shouldCheckPrivacy = true;
        Iterator iter = this.thumbnails.iterator();
        while (iter.hasNext()) {
            UploadImage attrs = (UploadImage)iter.next();
            if (!this.txtDescription.getText().equals(this.getNonNullString(attrs.getDescription()))) {
                this.txtDescription.setText("");
            }
            if (!this.txtTags.getText().equals(this.getNonNullString(TagParser.toInputString(attrs.getTags())))) {
                this.txtTags.setText("");
            }
            if (!this.txtTitle.getText().equals(this.getNonNullString(attrs.getTitle()))) {
                this.txtTitle.setText("");
            }
            if (shouldCheckPrivacy && this.radioPublic.getSelection() != attrs.isPubliclyVisible()) {
                this.radioPublic.setSelection(false);
                this.radioPrivate.setSelection(false);
                this.checkFamily.setEnabled(false);
                this.checkFriends.setEnabled(false);
                shouldCheckPrivacy = false;
            }
            if (shouldCheckFriends && this.checkFriends.getSelection() != attrs.isFriendViewable()) {
                this.checkFriends.setSelection(false);
                shouldCheckFriends = false;
            }
            if (!shouldCheckFamily || this.checkFamily.getSelection() == attrs.isFamilyViewable()) continue;
            this.checkFamily.setSelection(false);
            shouldCheckFamily = false;
        }
        if (this.radioPublic.getSelection()) {
            this.checkFamily.setEnabled(false);
            this.checkFriends.setEnabled(false);
        }
    }

    private String getNonNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    protected void rotateClicked(SelectionEvent event) {
        int rotation = 0;
        rotation = event.widget == this.rotateLeft ? 270 : 90;
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            ImageAttributes thumb = (ImageAttributes)this.thumbnails.get(i);
            thumb.setRotation((thumb.getRotation() + rotation) % 360);
        }
        this.thumbnailComposite.redraw();
        this.th.redraw();
    }

    public static void main(String[] args) {
        JUploadr uploadr = new JUploadr();
        File pearPath = new File(args[0]);
        ImageAttributes atts = new ImageAttributes(uploadr, uploadr.images, pearPath.getAbsolutePath());
        ArrayList<ImageAttributes> images = new ArrayList<ImageAttributes>();
        images.add(atts);
        MultiImageAttributesUI ui = new MultiImageAttributesUI(images);
        ui.show(ReusableUIFactory.getInstance().getDisplay());
    }
}

