/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.event.RescaleListener;

public class RescaleThread
implements Runnable {
    private static final int NUM_WORKER_THREADS = 2;
    private ImageData data;
    private Image scaled;
    private String imagePath;
    private RescaleListener listener;
    private static List queue = new LinkedList();
    private static ThreadGroup group = new ThreadGroup("worker-threads");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImage(String path, RescaleListener listener) {
        RescaleThread rescaleThread = new RescaleThread();
        rescaleThread.getClass();
        queue.add(rescaleThread.new PhotoInfo(path, listener));
        List list = queue;
        synchronized (list) {
            queue.notify();
        }
    }

    protected RescaleThread() {
    }

    public Image getScaledInstance() {
        return this.scaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Display display = Display.getDefault();
        while (true) {
            List list = queue;
            synchronized (list) {
                if (queue.size() == 0) {
                    try {
                        queue.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                PhotoInfo pi = (PhotoInfo)queue.remove(0);
                this.imagePath = pi.photoPath;
                this.listener = pi.listener;
            }
            try {
                Image orig = new Image((Device)display, this.imagePath);
                this.data = orig.getImageData();
                float scaleFactor = 250.0f / (float)this.data.width;
                int height = (int)Math.ceil(scaleFactor * (float)this.data.height);
                this.scaled = new Image((Device)display, 250, height);
                GC gfx = new GC((Drawable)this.scaled);
                gfx.drawImage(orig, 0, 0, this.data.width, this.data.height, 0, 0, 250, height);
                gfx.dispose();
                orig.dispose();
                this.listener.rescaleDone(this.scaled);
                continue;
            }
            catch (SWTException ex) {
                Object[] args = new Object[]{this.imagePath};
                this.listener.rescaleFailed(Messages.getString("juploadr.ui.error.format.unrecognized", args));
                continue;
            }
            break;
        }
    }

    static {
        for (int i = 0; i < 2; ++i) {
            RescaleThread t = new RescaleThread();
            Thread thread = new Thread(group, t);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private class PhotoInfo {
        public String photoPath;
        public RescaleListener listener;

        public PhotoInfo(String path, RescaleListener listener) {
            this.listener = listener;
            this.photoPath = path;
        }
    }
}

