/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app.scalers;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegQuantisationTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegReader;
import au.com.lastweekend.jim.io.jpeg.JpegWriter;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Metadata;
import java.io.File;
import java.util.Iterator;
import org.eclipse.swt.graphics.Point;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.ui.MessageUtils;

public abstract class Scaler {
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$exif$ExifDirectory;

    public boolean isOptimal() {
        return false;
    }

    public void scale(File original, File scaled, Point newSize) {
        this.doScale(original, scaled, newSize);
        this.copyMetadata(original, scaled, newSize);
    }

    public abstract void doScale(File var1, File var2, Point var3);

    private void copyMetadata(File origFile, File scaledFile, Point imageSize) {
        JpegWriter writer = new JpegWriter();
        JpegReader reader = new JpegReader();
        try {
            Metadata newMetadata = new Metadata();
            Metadata origMd = reader.readMetadata(origFile);
            Metadata scaledMd = reader.readImage(scaledFile);
            if (this.hasExif(origMd)) {
                Directory dir;
                Iterator iter = origMd.getDirectoryIterator();
                while (iter.hasNext() && !((dir = (Directory)iter.next()) instanceof JpegQuantisationTableDirectory)) {
                    newMetadata.addDirectory(dir);
                }
                iter = scaledMd.getDirectoryIterator();
                while (iter.hasNext()) {
                    newMetadata.addDirectory((Directory)iter.next());
                }
                this.fixMetadata(newMetadata, imageSize.x, imageSize.y);
                writer.writeImage(newMetadata, scaledFile);
            }
        }
        catch (JpegProcessingException e) {
            Object[] args = new Object[]{origFile.getName(), e.getMessage()};
            MessageUtils.showErrorMessage(Messages.getString("juploadr.ui.rescale.could.not.scale", args));
        }
    }

    private void fixMetadata(Metadata newMetadata, int width, int height) {
        Directory exif = newMetadata.getDirectory(class$au$com$lastweekend$jim$io$exif$ExifDirectory == null ? (class$au$com$lastweekend$jim$io$exif$ExifDirectory = Scaler.class$("au.com.lastweekend.jim.io.exif.ExifDirectory")) : class$au$com$lastweekend$jim$io$exif$ExifDirectory);
        if (exif != null) {
            exif.setTag(40963, 3, (Object)new Integer(height));
            exif.setTag(40962, 3, (Object)new Integer(width));
        }
    }

    private boolean hasExif(Metadata md) {
        Iterator iter = md.getDirectoryIterator();
        Package exifPackage = (class$au$com$lastweekend$jim$io$exif$ExifDirectory == null ? (class$au$com$lastweekend$jim$io$exif$ExifDirectory = Scaler.class$("au.com.lastweekend.jim.io.exif.ExifDirectory")) : class$au$com$lastweekend$jim$io$exif$ExifDirectory).getPackage();
        while (iter.hasNext()) {
            Directory d = (Directory)iter.next();
            if (!exifPackage.equals(d.getClass().getPackage())) continue;
            System.out.println("found EXIF");
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

