/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app.tags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.scohen.juploadr.app.tags.Tag;

public class TagParser {
    public static List parse(String input) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (input != null) {
            StringBuffer tag = new StringBuffer();
            boolean insideQuote = false;
            for (int i = 0; i < input.length(); ++i) {
                char currentChar = input.charAt(i);
                if (currentChar == ' ') {
                    if (!insideQuote) {
                        tags.add(new Tag(tag.toString()));
                        tag.delete(0, tag.length());
                        continue;
                    }
                    tag.append(currentChar);
                    continue;
                }
                if (currentChar == '\"') {
                    if (insideQuote) {
                        tags.add(new Tag(tag.toString()));
                        tag.delete(0, tag.length());
                        if (i + 1 < input.length() && input.charAt(i + 1) == ' ') {
                            ++i;
                        }
                    }
                    insideQuote = !insideQuote;
                    continue;
                }
                tag.append(currentChar);
            }
            tags.add(new Tag(tag.toString()));
        }
        return tags;
    }

    public static String toInputString(List tags) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            Tag t = (Tag)iter.next();
            sb.append(t.toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String toRequestString(List tags) {
        return TagParser.toInputString(tags);
    }

    public static void main(String[] args) {
        String tags = "tag1 tag2 tag3 tag4 tag5";
        System.out.println(TagParser.parse(tags));
        System.out.println(TagParser.toInputString(TagParser.parse(tags)));
    }
}

