/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.prefs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Version
implements Comparable {
    private String additional;
    private boolean hasAdditional;
    private int additionalVersion;
    public int[] parts;
    private static Pattern p = Pattern.compile("[\\d\\.]+((\\w+)(\\d{1,}))$");
    private static List rankings = new ArrayList();

    public Version(String vStr) {
        this.parse(vStr);
    }

    private void parse(String v) {
        Matcher m = p.matcher(v);
        if (m.matches()) {
            String which;
            this.additional = which = m.group(2);
            this.hasAdditional = true;
            this.additionalVersion = Integer.parseInt(m.group(3));
            v = v.substring(0, v.indexOf(m.group(1)));
        }
        String[] sParts = v.split("\\.");
        this.parts = new int[sParts.length];
        for (int i = 0; i < sParts.length; ++i) {
            this.parts[i] = Integer.parseInt(sParts[i]);
        }
    }

    public int compareTo(Object o) {
        Version another = (Version)o;
        int cmp = 0;
        for (int i = 0; i < this.parts.length; ++i) {
            if (i < another.parts.length) {
                if (this.parts[i] == another.parts[i]) continue;
                cmp = this.parts[i] - another.parts[i];
                break;
            }
            cmp = 1;
        }
        if (cmp == 0) {
            if (another.parts.length > this.parts.length) {
                cmp = -1;
            }
            if (this.hasAdditional || another.hasAdditional()) {
                cmp = this.compareSubVersions(this, another);
            }
        }
        return cmp;
    }

    private int compareSubVersions(Version version, Version another) {
        if (version.hasAdditional() && another.hasAdditional) {
            if (version.getAdditional().equalsIgnoreCase(another.getAdditional())) {
                return version.getAdditionalVersion() - another.getAdditionalVersion();
            }
            return rankings.indexOf(version.getAdditional()) - rankings.indexOf(another.getAdditional());
        }
        if (version.hasAdditional() && !another.hasAdditional()) {
            return -1;
        }
        return 1;
    }

    public String getAdditional() {
        return this.additional;
    }

    public int getAdditionalVersion() {
        return this.additionalVersion;
    }

    public boolean hasAdditional() {
        return this.hasAdditional;
    }

    static {
        rankings.add("alpha");
        rankings.add("beta");
        rankings.add("rc");
    }
}

