/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Sleak;

public class DefaultReusableUIFactory
extends ReusableUIFactory {
    private static final String UNKNOWN_RESOURCE = "org/scohen/juploadr/resources/unknown.png";
    private static final String TINYLOGO_RESOURCE = "org/scohen/juploadr/resources/icon.png";
    private static final String LOGO_RESOURCE = "org/scohen/juploadr/resources/logo.png";
    private static final String UPLOADED_RESOURCE = "org/scohen/juploadr/resources/uploaded.png";
    private static final String ROTATE_RIGHT_IMAGE = "org/scohen/juploadr/resources/rotate_right.png";
    private static final String ROTATE_LEFT_IMAGE = "org/scohen/juploadr/resources/rotate_left.png";
    private static final String UPLOADING_RESOURCE = "org/scohen/juploadr/resources/upload.png";
    private static final String PHOTOSET_IMAGE = "org/scohen/juploadr/resources/sets.png";
    private Display display;
    private Image uploadingImage;
    private Image uploadedImage;
    private Image unknownImage;
    private Image logoImage;
    private Image tinyLogoImage;
    private Image rotateRightImage;
    private Image rotateLeftImage;
    private Image photosetOverlayImage;
    private Color friendsColor;
    private Color familyColor;
    private Color privateColor;
    private Color publicColor;
    private Color tagColor;
    private Color descriptionColor;
    private Color titleColor;
    private Color thumbnailBorderColor;
    private Color thumbnailBackgroundColor;
    private Color thumbnailSelectedBackgroundColor;
    private Color tagBorderColor;
    private Color whiteColor;
    private Color blackColor;
    private Color aboutDialogFontColor;
    private Color progressBarColor;
    private Font authorizeHeaderFont;
    private Font authorizationFooterFont;
    private Font thumbnailDecorationFont;

    public DefaultReusableUIFactory() {
        boolean runSleak = Boolean.getBoolean("sleak");
        if (runSleak) {
            DeviceData data = new DeviceData();
            data.tracking = true;
            this.display = new Display(data);
            new Sleak().open();
        } else {
            this.display = new Display();
        }
        this.initializeElements();
    }

    private void initializeElements() {
        this.initializeImages();
        this.initializeColors();
        this.initializeFonts();
    }

    private void initializeFonts() {
        FontData thumbnailDecorationFd = new FontData("Sans", 9, 0);
        this.thumbnailDecorationFont = new Font((Device)this.display, thumbnailDecorationFd);
        FontData authFD = new FontData("Sans", 14, 1);
        this.authorizeHeaderFont = new Font((Device)this.display, authFD);
        FontData footerFontFD = new FontData("Sans", 9, 0);
        this.authorizationFooterFont = new Font((Device)this.display, footerFontFD);
    }

    private void initializeColors() {
        this.friendsColor = new Color((Device)this.display, 128, 32, 32);
        this.familyColor = new Color((Device)this.display, 128, 32, 32);
        this.privateColor = new Color((Device)this.display, 166, 0, 0);
        this.publicColor = new Color((Device)this.display, 0, 158, 59);
        this.tagColor = new Color((Device)this.display, 0, 89, 168);
        this.descriptionColor = new Color((Device)this.display, 0, 89, 168);
        this.titleColor = new Color((Device)this.display, 0, 89, 168);
        this.aboutDialogFontColor = new Color((Device)this.display, 100, 100, 100);
        this.thumbnailBorderColor = new Color((Device)this.display, 180, 180, 180);
        this.thumbnailBackgroundColor = new Color((Device)this.display, 250, 250, 250);
        this.thumbnailSelectedBackgroundColor = new Color((Device)this.display, 0, 110, 220);
        this.tagBorderColor = new Color((Device)this.display, 220, 220, 220);
        this.progressBarColor = new Color((Device)this.display, 0, 138, 255);
        this.whiteColor = new Color((Device)this.display, 255, 255, 255);
        this.blackColor = new Color((Device)this.display, 0, 0, 0);
    }

    private void initializeImages() {
        this.logoImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(LOGO_RESOURCE));
        this.tinyLogoImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(TINYLOGO_RESOURCE));
        this.uploadingImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(UPLOADING_RESOURCE));
        this.uploadedImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(UPLOADED_RESOURCE));
        this.unknownImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(UNKNOWN_RESOURCE));
        this.rotateRightImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(ROTATE_RIGHT_IMAGE));
        this.rotateLeftImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(ROTATE_LEFT_IMAGE));
        this.photosetOverlayImage = new Image((Device)this.display, this.getClass().getClassLoader().getResourceAsStream(PHOTOSET_IMAGE));
    }

    public void dispose() {
        this.disposeImages();
        this.disposeColors();
        this.disposeFonts();
        this.display.dispose();
    }

    private void disposeFonts() {
        this.thumbnailDecorationFont.dispose();
        this.authorizeHeaderFont.dispose();
        this.authorizationFooterFont.dispose();
    }

    private void disposeColors() {
        this.friendsColor.dispose();
        this.familyColor.dispose();
        this.privateColor.dispose();
        this.publicColor.dispose();
        this.tagColor.dispose();
        this.descriptionColor.dispose();
        this.titleColor.dispose();
        this.thumbnailBorderColor.dispose();
        this.thumbnailBackgroundColor.dispose();
        this.thumbnailSelectedBackgroundColor.dispose();
        this.tagBorderColor.dispose();
        this.progressBarColor.dispose();
        this.whiteColor.dispose();
        this.aboutDialogFontColor.dispose();
        this.blackColor.dispose();
    }

    private void disposeImages() {
        this.logoImage.dispose();
        this.tinyLogoImage.dispose();
        this.uploadingImage.dispose();
        this.uploadedImage.dispose();
        this.unknownImage.dispose();
        this.rotateLeftImage.dispose();
        this.rotateRightImage.dispose();
        this.photosetOverlayImage.dispose();
    }

    public Display getDisplay() {
        return this.display;
    }

    public Image getUploadingImage() {
        return this.uploadingImage;
    }

    public Image getUploadedImage() {
        return this.uploadedImage;
    }

    public Image getPhotosetOverlayImage() {
        return this.photosetOverlayImage;
    }

    public Color getFriendsColor() {
        return this.friendsColor;
    }

    public Color getFamilyColor() {
        return this.familyColor;
    }

    public Color getPrivateColor() {
        return this.privateColor;
    }

    public Color getPublicColor() {
        return this.publicColor;
    }

    public Color getThumbnailBorderColor() {
        return this.thumbnailBorderColor;
    }

    public Color getThumbnailBackgroundColor() {
        return this.thumbnailBackgroundColor;
    }

    public Color getAboutDialogFontColor() {
        return this.aboutDialogFontColor;
    }

    public Color getThumbnailSelectedBackgroundColor() {
        return this.thumbnailSelectedBackgroundColor;
    }

    public Color getTagColor() {
        return this.tagColor;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Color getWhiteColor() {
        return this.whiteColor;
    }

    public Color getBlackColor() {
        return this.blackColor;
    }

    public Color getTagBorderColor() {
        return this.tagBorderColor;
    }

    public Color getProgressBarColor() {
        return this.progressBarColor;
    }

    public Font getThumbnailDecorationFont() {
        return this.thumbnailDecorationFont;
    }

    public Image getLogoImage() {
        return this.logoImage;
    }

    public Image getTinyLogoImage() {
        return this.tinyLogoImage;
    }

    public Image getUnknownImage() {
        return this.unknownImage;
    }

    public Font getAuthorizeHeaderFont() {
        return this.authorizeHeaderFont;
    }

    public Font getAuthorizationFooterFont() {
        return this.authorizationFooterFont;
    }

    public Image getRotateLeftImage() {
        return this.rotateLeftImage;
    }

    public Image getRotateRightImage() {
        return this.rotateRightImage;
    }
}

