/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui.thumbnail;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.thumbnail.AbstractThumbnailDecorator;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;

public class PhotoSetThumbnailDecorator
extends AbstractThumbnailDecorator {
    private ImageAttributes atts;
    private Thumbnail thumb;
    private static ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();

    public PhotoSetThumbnailDecorator(Composite parent, ImageAttributes atts, Thumbnail t) {
        super(parent, atts, t);
        this.atts = atts;
        this.thumb = t;
    }

    void paintControl(PaintEvent e) {
        if (Configuration.getInstance().getUseImageLayovers() && this.atts.getPhotoSets() != null && this.atts.getPhotoSets().size() > 0) {
            GC gc = e.gc;
            int size = 0;
            if (this.atts.getPhotoSets() != null) {
                size = this.atts.getPhotoSets().size();
            }
            gc.setBackground(uiFactory.getWhiteColor());
            Image photosetImage = uiFactory.getPhotosetOverlayImage();
            ImageData data = this.thumb.getImage().getImageData();
            ImageData iconData = photosetImage.getImageData();
            int xPos = data.width - (iconData.width - 4);
            int yPos = 7;
            gc.setForeground(uiFactory.getWhiteColor());
            gc.drawImage(photosetImage, xPos, yPos);
            String sizeStr = String.valueOf(size);
            gc.setFont(uiFactory.getThumbnailDecorationFont());
            Point textSize = gc.textExtent(sizeStr);
            gc.drawString(sizeStr, xPos + iconData.width / 2 - textSize.x / 2, yPos + (iconData.height - 2) / 2 - textSize.y / 2, true);
        }
    }

    void widgetDisposed(DisposeEvent e) {
    }
}

