/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.upload;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.upload.BandwidthLimitingProtocolSocketFactory;

public class HttpClientFactory {
    public static HttpClient getHttpClient() {
        HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        Configuration config = Configuration.getInstance();
        Protocol http = config.isThrottlingEnabled() ? new Protocol("http", (ProtocolSocketFactory)new BandwidthLimitingProtocolSocketFactory(), 80) : new Protocol("http", (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 80);
        Protocol.registerProtocol((String)"http", (Protocol)http);
        if (config.isProxyEnabled()) {
            HostConfiguration hc = client.getHostConfiguration();
            String proxyHost = config.getProxyHost();
            String proxyPassword = config.getProxyPassword();
            String proxyUsername = config.getProxyUsername();
            int proxyPort = config.getProxyPort();
            hc.setProxy(proxyHost, proxyPort);
            if (proxyUsername.length() > 0) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                client.getParams().setAuthenticationPreemptive(true);
                AuthScope scope = new AuthScope(proxyHost, proxyPort);
                client.getState().setProxyCredentials(scope, (Credentials)creds);
            }
        }
        client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        client.getHttpConnectionManager().getParams().setSoTimeout(60000);
        return client;
    }
}

