/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.uploadapi.ImageUploadApi;

public abstract class Account {
    public static final int PRIVACY_PUBLIC = 1;
    public static final int PRIVACY_PRIVATE = 2;
    public static final int PRIVACY_FRIENDS = 4;
    public static final int PRIVACY_FAMILY = 8;
    protected String name;
    protected List defaultTags = new LinkedList();
    protected List userTags = new LinkedList();
    protected int defaultPrivacySetting = 1;
    protected boolean authenticated;
    protected Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    protected URL photoURL;
    private long currentUploadUsed;
    private long monthlyUploadLimit;
    protected String username;
    protected static URLCodec codec = new URLCodec();

    public Account(String name) {
        this.name = name;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract ImageUploadApi getApi();

    public synchronized void save() {
        this.save(this.prefs);
    }

    protected void save(Preferences prefs) {
        try {
            Map properties = BeanUtils.describe((Object)this);
            Iterator iter = properties.keySet().iterator();
            String encodedUsername = this.encodeUsername(this.name);
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String propertyName = Account.getShortClassName(this.getClass()) + "." + encodedUsername + "." + name;
                String value = (String)properties.get(name);
                if ("class".equals(name) || value == null || value.startsWith("[")) continue;
                prefs.put(propertyName, value.toString());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        try {
            String[] keys = this.prefs.keys();
            String encodedName = this.encodeUsername(this.name);
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].indexOf(encodedName) < 0) continue;
                this.prefs.remove(keys[i]);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected static Map allAccountsIn(Class accountClass, Preferences prefs) {
        HashMap usernames = new HashMap();
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String[] keyParts = keys[i].split("\\.");
                if (!Account.getShortClassName(accountClass).equals(keyParts[0])) continue;
                String decodedUsername = Account.decodeUsername(keyParts[1]);
                if (usernames.get(decodedUsername) == null) {
                    try {
                        usernames.put(decodedUsername, accountClass.newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                Object account = usernames.get(decodedUsername);
                String property = prefs.get(keys[i], "");
                if (property.startsWith("[")) continue;
                BeanUtils.setProperty(account, (String)keyParts[2], (Object)prefs.get(keys[i], ""));
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return usernames;
    }

    private static String getShortClassName(Class clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public long getMonthlyUploadLimit() {
        return this.monthlyUploadLimit;
    }

    public long getCurrentUploadUsed() {
        return this.currentUploadUsed;
    }

    public void setCurrentUploadUsed(long currentUploadUsed) {
        this.currentUploadUsed = currentUploadUsed;
    }

    public void setMonthlyUploadLimit(long monthlyUploadLimit) {
        this.monthlyUploadLimit = monthlyUploadLimit;
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            Account otherAccount = (Account)other;
            return this.getName().equals(otherAccount.getName());
        }
        return false;
    }

    public int getDefaultPrivacySetting() {
        return this.defaultPrivacySetting;
    }

    public void setDefaultPrivacySetting(int defaultPrivacySetting) {
        this.defaultPrivacySetting = defaultPrivacySetting;
    }

    public List getDefaultTags() {
        return Collections.unmodifiableList(this.defaultTags);
    }

    public void setSavedDefaultTags(String defaultTags) {
        this.defaultTags = TagParser.parse(defaultTags);
    }

    public String getSavedDefaultTags() {
        return TagParser.toInputString(this.defaultTags);
    }

    public void setDefaultTags(List defaultTags) {
        this.defaultTags = defaultTags;
    }

    public List getUserTags() {
        return this.userTags;
    }

    public void setUserTags(List userTags) {
        this.userTags = userTags;
    }

    public abstract URL getPhotoURL();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private String encodeUsername(String username) {
        String encoded = username;
        try {
            codec.encode(username);
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        encoded = encoded.replaceAll("\\.", "%2e");
        return encoded;
    }

    private static String decodeUsername(String encoded) {
        String decoded = "";
        try {
            decoded = codec.decode(encoded);
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        return decoded;
    }
}

