/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.ui;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.prefs.BaseConfigurationForm;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.prefs.Fault;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.FlickrAccount;
import org.scohen.juploadr.util.ConversionUtils;

public class FlickrForm
extends BaseConfigurationForm {
    private static final DecimalFormat percentFormat = new DecimalFormat("####0.##%");
    private Label accountTypeLabel;
    private Label accountType;
    private Label downloadLimitLabel;
    private Label downloadLimit;
    private Label authorizeLabel;
    private Button authorize;
    private Label accountsLabel;
    private Combo accounts;
    private Button deleteAccount;
    private Button addAnotherAccount;
    private Label addAnotherAccountLabel;

    public FlickrForm(Composite parent) {
        super(parent);
    }

    protected void initUI() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        this.setLayout((Layout)layout);
        if (this.api.isCurrentAccountAuthenticated()) {
            this.initAuthorizedComponents();
        }
        this.authorizeLabel = new Label((Composite)this, 0);
        this.authorizeLabel.setText("");
        this.authorize = new Button((Composite)this, 8);
        this.authorize.setImage(this.api.getIcon());
        if (!this.api.isCurrentAccountAuthenticated()) {
            this.authorize.setLayoutData((Object)new GridData(770));
        }
        this.authorize.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.button.validate.settings"));
        this.authorize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlickrForm.this.reauthAccount();
            }
        });
        this.addAnotherAccountLabel = new Label((Composite)this, 0);
        this.addAnotherAccountLabel.setText("");
        this.addAnotherAccount = new Button((Composite)this, 8);
        this.addAnotherAccount.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.flickrrest.flickrform.addaccount"));
        this.addAnotherAccount.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                FlickrAccount account = (FlickrAccount)FlickrForm.this.api.newAccount("--");
                FlickrForm.this.authorizeAccount(account, true);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FlickrForm.this.disposed(event);
            }
        });
    }

    private void initAuthorizedComponents() {
        FlickrAccount currentAccount = (FlickrAccount)this.api.getCurrentAccount();
        this.accountsLabel = new Label((Composite)this, 0);
        this.accountsLabel.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.label.username"));
        Composite accountComp = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(768);
        accountComp.setLayoutData((Object)data);
        accountComp.setLayout((Layout)layout);
        this.accounts = new Combo(accountComp, 12);
        this.accounts.setLayoutData((Object)new GridData(768));
        Iterator iter = FlickrAccount.allAccounts().values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Account account = (Account)iter.next();
            this.accounts.add(account.getName());
            if (account.equals((Object)currentAccount)) {
                this.accounts.select(i);
            }
            ++i;
        }
        this.accounts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.doit) {
                    Combo combo = (Combo)event.widget;
                    String accountName = combo.getItem(combo.getSelectionIndex());
                    FlickrAccount account = (FlickrAccount)((Object)FlickrAccount.allAccounts().get(accountName));
                    FlickrForm.this.api.setCurrentAccount((Account)account);
                    try {
                        FlickrForm.this.api.authenticate((Account)account);
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (CommunicationException e) {
                        MessageUtils.showErrorMessage((String)(Messages.getString((String)"juploadr.ui.dialog.error.communication") + e.getMessage()));
                    }
                    FlickrForm.this.accountChanged(account);
                }
            }
        });
        this.deleteAccount = new Button(accountComp, 8);
        this.deleteAccount.setText("Delete");
        this.deleteAccount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String accountName = FlickrForm.this.accounts.getItems()[FlickrForm.this.accounts.getSelectionIndex()];
                if (MessageUtils.showMessage((String)("Are you sure you want to delete the account " + accountName + "@" + ImageUploadApi.getInstance().getSiteName() + " and all of its preferences?"), (String)"Confirm Delete", (int)192)) {
                    Account account = (Account)FlickrAccount.allAccounts().get(accountName);
                    account.delete();
                    List allAccounts = RestFlickrApi.getInstance().allAccounts();
                    FlickrAccount changedAccount = FlickrAccount.getNullAccount();
                    if (allAccounts != null && allAccounts.size() > 0) {
                        changedAccount = (FlickrAccount)((Object)allAccounts.get(0));
                    }
                    RestFlickrApi.getInstance().setCurrentAccount((Account)changedAccount);
                    FlickrForm.this.accountChanged(changedAccount);
                }
            }
        });
        this.accountTypeLabel = new Label((Composite)this, 0);
        this.accountType = new Label((Composite)this, 0);
        this.accountTypeLabel.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.label.accounttype"));
        this.setAccountType(currentAccount);
        this.downloadLimitLabel = new Label((Composite)this, 0);
        this.downloadLimit = new Label((Composite)this, 0);
        this.downloadLimit.setLayoutData((Object)new GridData(768));
        this.downloadLimitLabel.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.label.montly.limit"));
        this.updateLimits();
    }

    private void setAccountType(FlickrAccount currentAccount) {
        this.accountType.setText(currentAccount.isPro() ? org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.account.pro") : org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.account.free"));
    }

    private void updateLimits() {
        Account currentAccount = this.api.getCurrentAccount();
        StringBuffer limitText = new StringBuffer();
        limitText.append(ConversionUtils.bytesToHumanReadable((long)currentAccount.getCurrentUploadUsed()));
        limitText.append("/");
        limitText.append(ConversionUtils.bytesToHumanReadable((long)currentAccount.getMonthlyUploadLimit()));
        limitText.append(" (");
        if (currentAccount.getMonthlyUploadLimit() > 0L) {
            limitText.append(percentFormat.format((double)currentAccount.getCurrentUploadUsed() / (double)currentAccount.getMonthlyUploadLimit()));
        } else {
            limitText.append(percentFormat.format(0L));
        }
        limitText.append(")");
        this.downloadLimit.setText(limitText.toString());
    }

    public void saveChanges() {
    }

    public Fault validateChanges() {
        return null;
    }

    public String getFormName() {
        return org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.flickrform.title");
    }

    private void reauthAccount() {
        Fault errors = this.validateChanges();
        if (errors != null) {
            MessageUtils.showErrorMessage((String)errors.getText());
        } else {
            boolean shouldRedraw = !this.api.isCurrentAccountAuthenticated();
            FlickrAccount userInfo = (FlickrAccount)this.api.getCurrentAccount();
            userInfo.setAuthenticated(false);
            this.authorizeAccount(userInfo, shouldRedraw);
        }
    }

    private void authorizeAccount(FlickrAccount account, boolean shouldRedraw) {
        Configuration config = Configuration.getInstance();
        if (!config.hasUpgraded()) {
            account.setToken(config.getOldToken());
            account.setUsername(config.getOldUsername());
            account.setAuthenticated(account.getToken().length() > 0);
        }
        try {
            if (this.api.authenticate((Account)account)) {
                account.setDefaultPrivacySetting(config.getDefaultPrivacySetting());
                account.setDefaultTags(TagParser.parse((String)config.getDefaultTags()));
                config.upgradeComplete();
                if (shouldRedraw) {
                    this.accountChanged(account);
                }
                MessageUtils.showInfoMessage((String)org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.dialog.account.info.correct"));
            }
        }
        catch (ProtocolException e) {
            MessageUtils.showErrorMessage((String)org.scohen.juploadr.uploadapi.flickrrest.Messages.getString("juploadr.ui.dialog.error.invalid.credentials"));
            Account defaultAccount = this.api.getCurrentAccount();
            if (defaultAccount == null) {
                defaultAccount = FlickrAccount.getNullAccount();
            }
            this.api.setCurrentAccount(defaultAccount);
        }
        catch (CommunicationException e) {
            MessageUtils.showErrorMessage((String)(Messages.getString((String)"juploadr.ui.dialog.error.communication") + e.getMessage()));
        }
    }

    private void accountChanged(FlickrAccount account) {
        this.resetUI();
        this.initUI();
        this.setAccountType(account);
        account.save();
        this.updateLimits();
        this.layout();
        this.parent.accountChanged();
    }

    public void accountChanged() {
    }

    private void disposed(DisposeEvent event) {
        if (this.api.isCurrentAccountAuthenticated()) {
            this.accountType.dispose();
            this.accountTypeLabel.dispose();
            this.downloadLimit.dispose();
            this.downloadLimitLabel.dispose();
            this.accounts.dispose();
            this.accountsLabel.dispose();
        }
        this.authorize.dispose();
        this.authorizeLabel.dispose();
        this.addAnotherAccount.dispose();
        this.addAnotherAccountLabel.dispose();
    }
}

