/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.ui.PopupData;
import org.scohen.juploadr.ui.PopupHandler;
import org.scohen.juploadr.uploadapi.flickrrest.Messages;
import org.scohen.juploadr.uploadapi.flickrrest.ui.NewPhotoSetDialog;

public class UploadThumbnailPopupHandler
extends PopupHandler {
    private static final String ADD_TO_SET = Messages.getString("juploadr.flickrrest.ui.popup.add.to");
    private static final String A_NEW_SET = Messages.getString("juploadr.flickrrest.ui.popup.add.to.new.set");
    private static String REMOVE_PHOTO = Messages.getString("juploadr.ui.popup.remove.photo");
    private static String EDIT_PHOTO = Messages.getString("juploadr.ui.popup.edit.photo");
    private static String SELECT_PHOTO = Messages.getString("juploadr.ui.popup.select.photo");
    private static String DESELECT_PHOTO = Messages.getString("juploadr.ui.popup.deselect.photo");
    private static String RE_UPLOAD_PHOTO = Messages.getString("juploadr.ui.popup.reupload.photo");
    private ImageAttributes atts;
    private List photoSets;

    public UploadThumbnailPopupHandler(Decorations parent, JUploadr uploadr, ImageAttributes clicked, List photoSets) {
        super(parent);
        this.atts = clicked;
        this.photoSets = photoSets;
        this.show();
    }

    protected void widgetSelected(SelectionEvent event) {
        MenuItem src = (MenuItem)event.widget;
        String action = src.getText();
        if (REMOVE_PHOTO.equals(action)) {
            this.atts.removeFromWindow();
        } else if (EDIT_PHOTO.equals(action)) {
            this.atts.openEditUI();
        } else if (SELECT_PHOTO.equals(action)) {
            this.atts.setSelected(true);
            this.atts.getButton().redraw();
        } else if (DESELECT_PHOTO.equals(action)) {
            this.atts.setSelected(false);
            this.atts.getButton().redraw();
        } else if (RE_UPLOAD_PHOTO.equals(action)) {
            this.atts.setState(2);
            this.atts.getButton().redraw();
        } else if (A_NEW_SET.equals(action)) {
            NewPhotoSetDialog dialog = new NewPhotoSetDialog(JUploadr.window, this.atts);
            dialog.open();
        } else {
            MenuItem item = (MenuItem)event.widget;
            PhotoSet set = (PhotoSet)item.getData();
            List alreadyAdded = this.atts.getPhotoSets();
            if (alreadyAdded.contains(set)) {
                set.removePhoto(this.atts);
            } else {
                set.addPhoto(this.atts);
            }
        }
    }

    protected void regenerateOptions() {
        this.options = new LinkedList();
        this.options.add(new PopupData(EDIT_PHOTO, true));
        if (this.atts.isSelected()) {
            this.options.add(new PopupData(DESELECT_PHOTO, true));
        } else {
            this.options.add(new PopupData(SELECT_PHOTO, true));
        }
        if (this.atts.getState() == 1) {
            this.options.add(new PopupData(RE_UPLOAD_PHOTO, true));
        } else {
            this.options.add(new PopupData(RE_UPLOAD_PHOTO, false));
        }
        this.options.add(PopupData.SEPARATOR);
        this.options.add(new PopupData(REMOVE_PHOTO, true));
        List alreadyAdded = this.atts.getPhotoSets();
        this.options.add(PopupData.SEPARATOR);
        if (this.photoSets != null && this.photoSets.size() > 0) {
            PopupData addToSet = new PopupData(ADD_TO_SET, true);
            this.options.add(addToSet);
            for (int i = 0; i < this.photoSets.size(); ++i) {
                PhotoSet photoSet = (PhotoSet)this.photoSets.get(i);
                PopupData data = new PopupData(photoSet.getTitle(), (Object)photoSet, true);
                data.setType(32);
                data.setChecked(alreadyAdded.contains(photoSet));
                addToSet.addChild(data);
                if (i <= 0 || i % 15 != 0) continue;
                PopupData next = new PopupData(Messages.getString("juploadr.flickrrest.ui.popup.more"), true);
                addToSet.getChildren().add(0, next);
                addToSet.getChildren().add(1, PopupData.SEPARATOR);
                addToSet = next;
            }
        }
        this.options.add(new PopupData(A_NEW_SET, true));
    }
}

