/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.DirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.exif.SkipTagDirectoryWriter;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Tag;
import au.com.lastweekend.jim.util.LoggingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTiffTagWriter
implements DirectoryWriter {
    private Directory _directory;
    private TiffTagFormat _dataFormat;
    private int _startOffset;
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$exif$AbstractTiffTagWriter == null ? (class$au$com$lastweekend$jim$io$exif$AbstractTiffTagWriter = AbstractTiffTagWriter.class$("au.com.lastweekend.jim.io.exif.AbstractTiffTagWriter")) : class$au$com$lastweekend$jim$io$exif$AbstractTiffTagWriter));
    private ExifTransform _transform;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$exif$AbstractTiffTagWriter;

    protected AbstractTiffTagWriter(Directory directory, ExifTransform exifTransform) {
        this._transform = exifTransform;
        this._directory = directory;
    }

    public void writeDirectory(OutputStream output) throws IOException {
        if (LOG.isDebugEnabled()) {
            this.debugStream("Writing " + this.getDirectory().getName(), output);
        }
        this.writeTags(output);
    }

    protected void writeTags(OutputStream output) throws IOException {
        int startOffset = this.getStartOffset();
        int writeableTagCount = this.getWriteableTagCount();
        int nextTagValueOffset = startOffset + 2 + 12 * writeableTagCount + 4;
        this.debugStream("TagCount: " + writeableTagCount, output);
        this._dataFormat.write16bits(writeableTagCount, output);
        Iterator tagIterator = this.getWriteableTagIterator();
        ArrayList longTagList = new ArrayList();
        while (tagIterator.hasNext()) {
            Tag tag = (Tag)tagIterator.next();
            nextTagValueOffset = this.writeTagInfo(tag, nextTagValueOffset, longTagList, output);
        }
        DirectoryWriter linkedDirectoryWriter = this.getLinkedDirectoryWriter(nextTagValueOffset);
        int linkedDirectoryLength = linkedDirectoryWriter.getDirectoryLength();
        int linkedDirectoryOffset = linkedDirectoryLength == 0 ? 0 : nextTagValueOffset;
        this._dataFormat.write32bits(linkedDirectoryOffset, output);
        Iterator iter = longTagList.iterator();
        while (iter.hasNext()) {
            Object longTag = iter.next();
            this.writeLongTag(longTag, output);
        }
        linkedDirectoryWriter.writeDirectory(output);
    }

    protected void writeLongTag(Object longTag, OutputStream output) throws IOException {
        if (longTag instanceof DirectoryWriter) {
            DirectoryWriter directoryWriter = (DirectoryWriter)longTag;
            directoryWriter.writeDirectory(output);
        } else {
            Tag tag = (Tag)longTag;
            if (LOG.isDebugEnabled()) {
                this.debugStream("Long tag: " + tag, output);
            }
            int tagType = tag.getTagType();
            Object tagValue = this.getTransformedTagValue(tagType);
            int formatCode = tag.getFormatCode();
            this._dataFormat.writeValue(tagValue, formatCode, output);
        }
    }

    protected int writeTagInfo(Tag tag, int nextTagValueOffset, List longTagList, OutputStream output) throws IOException {
        int formatCode = tag.getFormatCode();
        int tagType = tag.getTagType();
        Object tagValue = this.getTransformedTagValue(tagType);
        int componentCount = 0;
        int fillLength = 0;
        boolean writeOffset = false;
        int returnOffset = nextTagValueOffset;
        if (tagValue instanceof Directory) {
            DirectoryWriter directoryWriter = this.getDirectoryWriter(tagType, (Directory)tagValue, nextTagValueOffset);
            if (directoryWriter instanceof SkipTagDirectoryWriter) {
                tagType = 43690;
                formatCode = 4;
                componentCount = 1;
                tagValue = new Integer(0);
            } else {
                writeOffset = true;
                componentCount = directoryWriter.getComponentCount();
                returnOffset = nextTagValueOffset + directoryWriter.getDirectoryLength();
                longTagList.add(directoryWriter);
            }
        } else {
            componentCount = this._dataFormat.getComponentCount(tagValue);
            int valueLength = this._dataFormat.getByteCount(formatCode, componentCount);
            if (valueLength > 4) {
                returnOffset = nextTagValueOffset + this.getTagDataLength(tagType, tagValue, formatCode);
                longTagList.add(tag);
                writeOffset = true;
            } else {
                fillLength = 4 - valueLength;
            }
        }
        if (writeOffset) {
            this.writeOffsetTagInfoHeader(tagType, formatCode, componentCount, nextTagValueOffset, output);
        } else {
            this.writeSmallValueTagInfoHeader(tagType, formatCode, componentCount, tagValue, fillLength, output);
        }
        return returnOffset;
    }

    protected Object getTransformedTagValue(int tagType) {
        return this.getDirectory().getObject(tagType);
    }

    private void writeCommonTagInfoHeader(int tagType, int formatCode, int componentCount, OutputStream output) throws IOException {
        this._dataFormat.write16bits(tagType, output);
        this._dataFormat.write16bits(formatCode, output);
        this._dataFormat.write32bits(componentCount, output);
    }

    protected void writeOffsetTagInfoHeader(int tagType, int formatCode, int componentCount, int nextTagValueOffset, OutputStream output) throws IOException {
        if (LOG.isDebugEnabled()) {
            this.debugStream("TagHeader: " + this.getDirectory().getTagName(tagType) + " for offset " + nextTagValueOffset, output);
        }
        this.writeCommonTagInfoHeader(tagType, formatCode, componentCount, output);
        this._dataFormat.write32bits(nextTagValueOffset, output);
    }

    protected void writeSmallValueTagInfoHeader(int tagType, int formatCode, int componentCount, Object tagValue, int fillLength, OutputStream output) throws IOException {
        if (LOG.isDebugEnabled()) {
            this.debugStream("TagHeader: " + this.getDirectory().getTagName(tagType) + "," + formatCode + "," + componentCount + " as small value " + tagValue, output);
        }
        this.writeCommonTagInfoHeader(tagType, formatCode, componentCount, output);
        this._dataFormat.writeValue(tagValue, formatCode, output);
        for (int i = 0; i < fillLength; ++i) {
            output.write(0);
        }
    }

    protected int getTagDataLength(int tagType, Object tagValue, int formatCode) {
        int tagLength;
        if (tagValue instanceof Directory) {
            DirectoryWriter directoryWriter = this.getDirectoryWriter(tagType, (Directory)tagValue, 0);
            tagLength = directoryWriter.getDirectoryLength();
        } else {
            tagLength = this._dataFormat.getFormattedSize(tagValue, formatCode);
        }
        return tagLength;
    }

    protected DirectoryWriter getDirectoryWriter(int tagType, Directory directory, int startOffset) {
        LOG.warn((Object)("No writer for subdirectory tag " + tagType + ":" + directory));
        return new SkipTagDirectoryWriter();
    }

    public int getDirectoryLength() {
        int directoryLength = 2 + 12 * this.getWriteableTagCount() + 4;
        Iterator iterator = this.getWriteableTagIterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            int tagLength = this.getTagDataLength(tag.getTagType(), this.getDirectory().getObject(tag.getTagType()), tag.getFormatCode());
            if (tagLength <= 4) continue;
            directoryLength += tagLength;
        }
        return directoryLength += this.getLinkedDirectoryWriter(0).getDirectoryLength();
    }

    protected Iterator getWriteableTagIterator() {
        return this.getDirectory().getTagIterator();
    }

    protected int getWriteableTagCount() {
        return this.getDirectory().getTagCount();
    }

    protected DirectoryWriter getLinkedDirectoryWriter(int startOffset) {
        if (this._directory.getLinkedDirectory() != null) {
            LOG.warn((Object)("No writer for linked directory " + this._directory.getLinkedDirectory()));
        }
        return new SkipTagDirectoryWriter();
    }

    protected void setDataFormat(TiffTagFormat dataFormat) {
        this._dataFormat = dataFormat;
    }

    public TiffTagFormat getDataFormat() {
        return this._dataFormat;
    }

    protected Directory getDirectory() {
        return this._directory;
    }

    protected int getStartOffset() {
        return this._startOffset;
    }

    protected void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    protected void debugStream(String msg, OutputStream output) {
        String streamPosition = "";
        if (output instanceof LoggingOutputStream) {
            streamPosition = ((LoggingOutputStream)output).getStreamPosition();
        }
        LOG.debug((Object)(msg + " at " + streamPosition));
    }

    public ExifTransform getExifTransform() {
        return this._transform;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

