/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagWriter;
import au.com.lastweekend.jim.io.exif.DirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.ExifInteropDirectory;
import au.com.lastweekend.jim.io.exif.ExifInteropDirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteRegistry;
import au.com.lastweekend.jim.io.metadata.Directory;

public class ExifDirectoryWriter
extends AbstractTiffTagWriter {
    protected ExifDirectoryWriter(ExifDirectory directory, ExifTransform transform) {
        super(directory, transform);
    }

    protected DirectoryWriter getDirectoryWriter(int tagType, Directory directory, int startOffset) {
        switch (tagType) {
            case 37500: {
                return MakernoteRegistry.getWriter(this, directory, startOffset);
            }
            case 40965: {
                ExifInteropDirectoryWriter interopWriter = new ExifInteropDirectoryWriter((ExifInteropDirectory)directory, this.getExifTransform());
                interopWriter.setDataFormat(this.getDataFormat());
                interopWriter.setStartOffset(startOffset);
                return interopWriter;
            }
        }
        return super.getDirectoryWriter(tagType, directory, startOffset);
    }

    public int getComponentCount() {
        return 1;
    }

    protected Object getTransformedTagValue(int tagType) {
        if (this.getExifTransform().isXYTransposed()) {
            if (tagType == 40963) {
                return this.getDirectory().getObject(40962);
            }
            if (tagType == 40962) {
                return this.getDirectory().getObject(40963);
            }
            if (tagType == 41486) {
                return this.getDirectory().getObject(41487);
            }
            if (tagType == 41487) {
                return this.getDirectory().getObject(41486);
            }
        }
        return super.getTransformedTagValue(tagType);
    }
}

