/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.ExifDescriptor;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;

public class ExifInteropDescriptor
extends TagDescriptor {
    public ExifInteropDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 1: {
                return this.getInteropIndexDescription();
            }
            case 2: {
                return this.getInteropVersionDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getInteropVersionDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(2)) {
            return null;
        }
        int[] ints = this.getDirectory().getIntArray(2);
        return ExifDescriptor.convertBytesToVersionString(ints);
    }

    private String getInteropIndexDescription() {
        if (!this.getDirectory().containsTag(1)) {
            return null;
        }
        String interopIndex = this.getDirectory().getString(1).trim();
        if ("R98".equalsIgnoreCase(interopIndex)) {
            return "Recommended Exif Interoperability Rules (ExifR98)";
        }
        return "Unknown (" + interopIndex + ")";
    }
}

