/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagReader;
import au.com.lastweekend.jim.io.exif.ExifDirectoryReader;
import au.com.lastweekend.jim.io.exif.GPSDirectoryReader;
import au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectoryReader;
import au.com.lastweekend.jim.io.exif.TiffDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.metadata.Directory;

public class TiffDirectoryReader
extends AbstractTiffTagReader {
    public TiffDirectoryReader(byte[] data) {
        super(data);
    }

    public Directory extract(Directory parentDirectory) throws TiffTagProcessingException {
        TiffDirectory tiffDirectory = new TiffDirectory();
        this.setDirectory(tiffDirectory);
        this.processTiffHeader();
        this.processTiffTags();
        return this.getDirectory();
    }

    protected AbstractTiffTagReader getLinkedDirectoryReader() {
        int linkedDirectoryOffset = this.getLinkedDirectoryOffset();
        if (linkedDirectoryOffset > 0) {
            ThumbnailTiffDirectoryReader linkedReader = new ThumbnailTiffDirectoryReader(this.getData());
            linkedReader.setDataFormat(this.getDataFormat());
            linkedReader.setStartOffset(linkedDirectoryOffset);
            return linkedReader;
        }
        return null;
    }

    protected void processTag(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        switch (tagType) {
            case 34665: {
                this.processSubDirectory(new ExifDirectoryReader(this.getData()), tagType, formatCode, componentCount, tagValueOffset);
                break;
            }
            case 34853: {
                this.processSubDirectory(new GPSDirectoryReader(this.getData()), tagType, formatCode, componentCount, tagValueOffset);
                break;
            }
            default: {
                super.processTag(tagType, formatCode, componentCount, tagValueOffset);
            }
        }
    }

    public Directory extract() throws TiffTagProcessingException {
        return this.extract(null);
    }

    protected void setDirectoryByteOrder(boolean isMotorolaByteOrder) {
        TiffDirectory tiffDirectory = (TiffDirectory)this.getDirectory();
        tiffDirectory.setMotorolaByteOrder(isMotorolaByteOrder);
    }
}

