/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote;

import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.UnknownMakernoteDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;

public class UnknownMakernoteReader
implements MakernoteReader {
    private int _componentCount;
    private int _formatCode;
    private int _startOffset;
    private byte[] _data;

    public UnknownMakernoteReader(byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        this._data = data;
        this._startOffset = tagValueOffset;
        this._formatCode = formatCode;
        this._componentCount = componentCount;
    }

    public Directory extractMakernote(Directory parentDirectory) throws MakernoteException {
        int byteCount = new TiffTagFormat(false).getByteCount(this._formatCode, this._componentCount);
        if (this._startOffset + byteCount > this._data.length) {
            throw new MakernoteException("Invalid Maker note length");
        }
        UnknownMakernoteDirectory subDirectory = new UnknownMakernoteDirectory(parentDirectory, this._data, this._startOffset, byteCount);
        return subDirectory;
    }
}

