/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.minolta;

import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteException;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaCameraSettingsDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;

public class MinoltaCameraSettingsReader {
    private TiffTagFormat _format;
    private int _tagValueOffset;
    private int _componentCount;
    private int _formatCode;
    private byte[] _data;
    private Directory _directory;

    public MinoltaCameraSettingsReader(byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        this._data = data;
        this._formatCode = 4;
        this._format = new TiffTagFormat(true);
        this._componentCount = componentCount / 4;
        this._tagValueOffset = tagValueOffset;
    }

    public Directory extract(Directory parent) throws MakernoteException {
        this._directory = new MinoltaCameraSettingsDirectory(parent);
        this.processIntArray();
        return this._directory;
    }

    private void processIntArray() throws MakernoteException {
        int[] ints;
        try {
            ints = (int[])this._format.parse(this._data, this._formatCode, this._componentCount, this._tagValueOffset);
        }
        catch (TiffTagProcessingException e) {
            throw new MakernoteException(e);
        }
        for (int i = 0; i < ints.length; ++i) {
            int tagType = 3073 + i;
            if (i == 51 && ints.length == 51) {
                tagType = 52;
            }
            this._directory.setTag(tagType, this._formatCode, new Integer(ints[i]));
        }
    }
}

