/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.minolta;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;

public class MinoltaMakernoteDescriptor
extends TagDescriptor {
    public MinoltaMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 16: 
            case 32: 
            case 3840: {
                return this.getUnknownBinaryDescription(tagType);
            }
            case 64: 
            case 136: 
            case 137: 
            case 256: {
                return this.getIntegerDescription(tagType);
            }
            case 129: {
                return this.getThumbnailDataDescription();
            }
            case 257: {
                return this.getColourModeDescription();
            }
            case 258: 
            case 259: {
                return this.getImageQualityDescription(tagType);
            }
            case 3584: {
                return this.getPIMDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getIntegerDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int value = this.getDirectory().getInt(tagType);
        return value + "";
    }

    private String getPIMDescription() throws MetadataException {
        int tagType = 3584;
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        byte[] binaryData = this.getDirectory().getByteArray(tagType);
        return binaryData.length + " bytes of undecoded PIM data";
    }

    private String getImageQualityDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int quality = this.getDirectory().getInt(tagType);
        switch (quality) {
            case 0: {
                return "Raw";
            }
            case 1: {
                return "Super-fine";
            }
            case 2: {
                return "Fine";
            }
            case 3: {
                return "Standard";
            }
            case 5: {
                return "Extra-fine";
            }
        }
        return null;
    }

    private String getColourModeDescription() throws MetadataException {
        int tagType = 257;
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int mode = this.getDirectory().getInt(tagType);
        switch (mode) {
            case 0: {
                return "Natural Colour";
            }
            case 1: {
                return "Black & White";
            }
            case 2: {
                return "Vivid Colour";
            }
            case 3: {
                return "Solarization";
            }
            case 4: {
                return "AdobeRGB";
            }
        }
        return null;
    }

    private String getThumbnailDataDescription() throws MetadataException {
        int tagType = 129;
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        byte[] binaryData = this.getDirectory().getByteArray(tagType);
        return binaryData.length + " bytes of Thumbnail data";
    }

    private String getUnknownBinaryDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        byte[] binaryData = this.getDirectory().getByteArray(tagType);
        return binaryData.length + " bytes of undecoded data";
    }

    private String getSettingsDescription(int tagType) {
        return "Undecoded settings";
    }
}

