/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.nikon;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagReader;
import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.nikon.NikonType3MakernoteDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;

public class NikonType3MakerNoteReader
extends AbstractTiffTagReader
implements MakernoteReader {
    private static byte[] getSubData(byte[] exifData, int componentCount, int tagValueOffset) {
        byte[] makernoteIFD = new byte[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            makernoteIFD[i] = exifData[tagValueOffset + i];
        }
        return makernoteIFD;
    }

    public NikonType3MakerNoteReader(ExifDirectory directory, TiffTagFormat dataFormat, byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        super(NikonType3MakerNoteReader.getSubData(data, componentCount, tagValueOffset + 10));
    }

    public Directory extract(Directory parentDirectory) throws TiffTagProcessingException {
        this.setDirectory(new NikonType3MakernoteDirectory(parentDirectory));
        this.processTiffHeader();
        this.processTiffTags();
        return this.getDirectory();
    }

    protected AbstractTiffTagReader getLinkedDirectoryReader() {
        return null;
    }

    public Directory extractMakernote(Directory parentDirectory) throws MakernoteException {
        try {
            return this.extract(parentDirectory);
        }
        catch (TiffTagProcessingException e) {
            throw new MakernoteException(e);
        }
    }
}

