/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HuffmanTable {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$HuffmanTable == null ? (class$au$com$lastweekend$jim$io$jpeg$HuffmanTable = HuffmanTable.class$("au.com.lastweekend.jim.io.jpeg.HuffmanTable")) : class$au$com$lastweekend$jim$io$jpeg$HuffmanTable));
    private byte[][] _huffmanValues;
    private int[] _minCode;
    private int[] _maxCode;
    private byte[] _sizes;
    private int[] _codes;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$HuffmanTable;

    public HuffmanTable(byte[][] huffmanValues) {
        this._huffmanValues = huffmanValues;
        this.initialiseDecoder();
        this.initialiseEncoder();
    }

    private void initialiseDecoder() {
        if (this._minCode != null) {
            return;
        }
        this._minCode = new int[16];
        this._maxCode = new int[16];
        int code = 0;
        for (int i = 0; i < 16; ++i) {
            int numberOfCodes = this._huffmanValues[i].length;
            this._maxCode[i] = -1;
            this._minCode[i] = code;
            for (int j = 0; j < numberOfCodes; ++j) {
                this._maxCode[i] = code++;
            }
            code <<= 1;
        }
    }

    public byte decode(JpegBitBuffer bitBuffer) throws JpegProcessingException {
        int code;
        int codeLength = 0;
        for (code = bitBuffer.getBits(1); code > this._maxCode[codeLength]; code += bitBuffer.getBits(1)) {
            code <<= 1;
            if (++codeLength <= 15) continue;
            throw new JpegProcessingException("Unknown huffman code");
        }
        int valueIndex = code - this._minCode[codeLength];
        return this._huffmanValues[codeLength][valueIndex];
    }

    public void encode(int value, JpegBitOutput bitOutput) throws JpegProcessingException {
        int indexValue = value & 0xFF;
        bitOutput.writeBits(this._sizes[indexValue], this._codes[indexValue]);
    }

    private void initialiseEncoder() {
        int i;
        if (this._codes != null) {
            return;
        }
        this._codes = new int[255];
        this._sizes = new byte[255];
        int code = 0;
        for (i = 0; i < 16; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < this._huffmanValues[i].length; ++j) {
                int value = this._huffmanValues[i][j] & 0xFF;
                this._sizes[value] = (byte)(i + 1);
                this._codes[value] = code++;
            }
            code <<= 1;
        }
        if (LOG.isDebugEnabled()) {
            for (i = 0; i < 255; ++i) {
                LOG.debug((Object)(i + "\t" + Integer.toString(this._sizes[i] + 1) + "\t" + Integer.toBinaryString(this._codes[i])));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

