/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.DCTBlock;
import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOps;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.ScanComponent;

public class MatrixEncodedDCTBlock
extends DCTBlock {
    private int[][] _dctValues;
    private static final int ZRL = 240;
    private int _lastNonZeroIndex;
    private static final int EOB = 0;

    public MatrixEncodedDCTBlock(int[][] transformedCoefficients, int lastNonZeroIndex) {
        this._dctValues = transformedCoefficients;
        this._lastNonZeroIndex = lastNonZeroIndex;
    }

    public void writeCoefficients(ScanComponent component, JpegBitOutput bitOutput) throws JpegProcessingException {
        this.encodeDCCoefficient(component.getDCHuffmanTable(), component.getDCPredictor(), bitOutput);
        this.encodeACCoefficients(component.getACHuffmanTable(), bitOutput);
    }

    private void encodeACCoefficients(HuffmanTable huffmanTable, JpegBitOutput bitOutput) throws JpegProcessingException {
        int rrrr = 0;
        int zrlCount = 0;
        for (int i = 1; i <= this._lastNonZeroIndex; ++i) {
            int value = this._dctValues[ZIG_ZAG_X[i]][ZIG_ZAG_Y[i]];
            if (value == 0) {
                if (++rrrr != 16) continue;
                rrrr = 0;
                ++zrlCount;
                continue;
            }
            for (int z = 0; z < zrlCount; ++z) {
                huffmanTable.encode(240, bitOutput);
                if (!bitOutput.isDebugEnabled()) continue;
                bitOutput.debug("ACenc: ZRL for 16 consecutive zeroes");
            }
            zrlCount = 0;
            int size = JpegBitOps.getCategorySize(value);
            int rrrrssss = (rrrr << 4) + size & 0xFF;
            if (bitOutput.isDebugEnabled()) {
                bitOutput.debug("ACenc rrrr=" + rrrr + " ssss=" + size + " value=" + value);
            }
            huffmanTable.encode(rrrrssss, bitOutput);
            if (value < 0) {
                --value;
            }
            bitOutput.writeBits(size, value);
            rrrr = 0;
        }
        if (this._lastNonZeroIndex < 63 || rrrr != 0 || zrlCount != 0) {
            huffmanTable.encode(0, bitOutput);
        }
    }

    public void readCoefficients(ScanComponent component, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        throw new UnsupportedOperationException("Not implemented, not required");
    }

    public int getDCCoefficient() {
        return this._dctValues[0][0];
    }

    public byte[] getIndexes() {
        throw new UnsupportedOperationException("Not implemented, not required");
    }

    public short[] getNonZeroValues() {
        throw new UnsupportedOperationException("Not implemented, not required");
    }
}

