/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.jpeg.read.ExifSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.HuffmanTableSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReaderRegistry;
import au.com.lastweekend.jim.io.jpeg.read.QuantisationTableSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.RawSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.RestartIntervalSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.StartOfFrameSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.StartOfScanSegmentReader;

public class AllSegmentsReaderRegistry
implements JpegSegmentReaderRegistry {
    public JpegSegmentReader getSegmentReader(byte identifier) {
        JpegSegmentReader segmentReader;
        switch (identifier) {
            case -31: {
                segmentReader = new ExifSegmentReader();
                break;
            }
            case -64: 
            case -63: {
                segmentReader = new StartOfFrameSegmentReader();
                break;
            }
            case -60: {
                segmentReader = new HuffmanTableSegmentReader();
                break;
            }
            case -38: {
                segmentReader = new StartOfScanSegmentReader();
                break;
            }
            case -37: {
                segmentReader = new QuantisationTableSegmentReader();
                break;
            }
            case -35: {
                segmentReader = new RestartIntervalSegmentReader();
                break;
            }
            default: {
                segmentReader = new RawSegmentReader();
            }
        }
        return segmentReader;
    }
}

