/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.exif.TiffDirectoryReader;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.metadata.Directory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExifSegmentReader
implements JpegSegmentReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$read$ExifSegmentReader == null ? (class$au$com$lastweekend$jim$io$jpeg$read$ExifSegmentReader = ExifSegmentReader.class$("au.com.lastweekend.jim.io.jpeg.read.ExifSegmentReader")) : class$au$com$lastweekend$jim$io$jpeg$read$ExifSegmentReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$read$ExifSegmentReader;

    public Directory extractDirectory(JpegSegment segment) throws JpegProcessingException {
        if (segment.getIdentifier() != -31) {
            LOG.warn((Object)("Bad segment identifier " + segment.getIdentifier()));
            return null;
        }
        byte[] segmentData = segment.getData();
        if (segmentData.length < 6) {
            LOG.warn((Object)("Data length " + segmentData.length + " too short"));
            return null;
        }
        String exifIdentifier = new String(segmentData, 0, 6);
        if (!"Exif\u0000\u0000".equals(exifIdentifier)) {
            LOG.warn((Object)("Invalid exif identifier - " + exifIdentifier));
            return null;
        }
        return this.extractDirectory(this.getRawExifData(segmentData));
    }

    protected Directory extractDirectory(byte[] tiffExifData) throws JpegProcessingException {
        TiffDirectoryReader tiffReader = new TiffDirectoryReader(tiffExifData);
        try {
            return tiffReader.extract();
        }
        catch (TiffTagProcessingException e) {
            throw new JpegProcessingException(e);
        }
    }

    private byte[] getRawExifData(byte[] segmentData) {
        int exifDataLength = segmentData.length - 6;
        byte[] rawExifData = new byte[exifDataLength];
        for (int i = 0; i < exifDataLength; ++i) {
            rawExifData[i] = segmentData[i + 6];
        }
        return rawExifData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

