/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegQuantisationTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuantisationTableSegmentReader
implements JpegSegmentReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$read$QuantisationTableSegmentReader == null ? (class$au$com$lastweekend$jim$io$jpeg$read$QuantisationTableSegmentReader = QuantisationTableSegmentReader.class$("au.com.lastweekend.jim.io.jpeg.read.QuantisationTableSegmentReader")) : class$au$com$lastweekend$jim$io$jpeg$read$QuantisationTableSegmentReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$read$QuantisationTableSegmentReader;

    public Directory extractDirectory(JpegSegment segment) throws JpegProcessingException {
        JpegQuantisationTableDirectory directory;
        JpegQuantisationTableDirectory currentDirectory = directory = new JpegQuantisationTableDirectory(null, segment);
        int offset = 0;
        while (true) {
            byte quantisationPrecision;
            if ((quantisationPrecision = segment.getHigh4Bits(offset)) != 0) {
                throw new UnsupportedOperationException("Only supports 16 bit precision, expecting Pq = 0, got Pq=" + quantisationPrecision);
            }
            byte quantisationTableID = segment.getLow4Bits(offset);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DQT: id=" + quantisationTableID + " prec=" + quantisationPrecision + " at offset " + offset));
            }
            byte[] quantisationElements = new byte[64];
            for (int i = 0; i < 64; ++i) {
                quantisationElements[i] = segment.get8Bits(offset + 1 + i);
            }
            currentDirectory.setValue(1, quantisationPrecision);
            currentDirectory.setValue(2, quantisationTableID);
            currentDirectory.setValue(3, quantisationElements);
            if ((offset += 65) >= segment.getSize()) break;
            JpegQuantisationTableDirectory nextDirectory = new JpegQuantisationTableDirectory(currentDirectory, segment);
            try {
                currentDirectory.addLinkedDirectory(nextDirectory);
            }
            catch (MetadataException e) {
                throw new JpegProcessingException(e);
            }
            currentDirectory = nextDirectory;
        }
        return directory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

