/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.write;

import au.com.lastweekend.jim.io.exif.TiffDirectory;
import au.com.lastweekend.jim.io.jpeg.HuffmanTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegImageDataDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegQuantisationTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegScanDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegStartOfFrameDirectory;
import au.com.lastweekend.jim.io.jpeg.RawJpegSegmentDirectory;
import au.com.lastweekend.jim.io.jpeg.write.ExifDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.HuffmanTableDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegCompressedDataWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegDirectoryWriterRegistry;
import au.com.lastweekend.jim.io.jpeg.write.JpegScanDataWriter;
import au.com.lastweekend.jim.io.jpeg.write.QuantisationTableSegmentWriter;
import au.com.lastweekend.jim.io.jpeg.write.RawSegmentDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.StartOfFrameSegmentWriter;
import au.com.lastweekend.jim.io.metadata.Directory;

public class DefaultDirectoryWriterRegistry
implements JpegDirectoryWriterRegistry {
    private static final JpegDirectoryWriter EXIF_SEGMENT_WRITER = new ExifDirectoryWriter();
    private static final JpegDirectoryWriter RAW_SEGMENT_WRITER = new RawSegmentDirectoryWriter();
    private static final JpegCompressedDataWriter COMPRESSED_DATA_WRITER = new JpegCompressedDataWriter();
    private static final JpegScanDataWriter SCAN_DATA_WRITER = new JpegScanDataWriter();
    private static final StartOfFrameSegmentWriter SOF_WRITER = new StartOfFrameSegmentWriter();
    private static final QuantisationTableSegmentWriter DQT_WRITER = new QuantisationTableSegmentWriter();
    private static final HuffmanTableDirectoryWriter HUFF_WRITER = new HuffmanTableDirectoryWriter();

    public JpegDirectoryWriter getDirectoryWriter(Directory directory) {
        if (directory instanceof TiffDirectory) {
            return EXIF_SEGMENT_WRITER;
        }
        if (directory instanceof JpegImageDataDirectory) {
            return COMPRESSED_DATA_WRITER;
        }
        if (directory instanceof JpegScanDirectory) {
            return SCAN_DATA_WRITER;
        }
        if (directory instanceof JpegStartOfFrameDirectory) {
            return SOF_WRITER;
        }
        if (directory instanceof JpegQuantisationTableDirectory) {
            return DQT_WRITER;
        }
        if (directory instanceof HuffmanTableDirectory) {
            return HUFF_WRITER;
        }
        if (directory instanceof RawJpegSegmentDirectory) {
            return RAW_SEGMENT_WRITER;
        }
        return null;
    }
}

