/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibWarpGridOpImage;
import com.sun.media.jai.mlib.MlibWarpGridTableOpImage;
import com.sun.media.jai.mlib.MlibWarpPolynomialOpImage;
import com.sun.media.jai.mlib.MlibWarpPolynomialTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;
import javax.media.jai.Warp;
import javax.media.jai.WarpGrid;
import javax.media.jai.WarpPolynomial;

public class MlibWarpRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout) || renderedImage.getTileWidth() >= 32768 || renderedImage.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        Warp warp = (Warp)parameterBlock.getObjectParameter(0);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(1);
        double[] dArray = (double[])parameterBlock.getObjectParameter(2);
        int n = -1;
        if (interpolation instanceof InterpolationNearest) {
            n = 0;
        } else if (interpolation instanceof InterpolationBilinear) {
            n = 1;
        } else if (interpolation instanceof InterpolationBicubic) {
            n = 2;
        } else if (interpolation instanceof InterpolationBicubic2) {
            n = 3;
        } else if (!(interpolation instanceof InterpolationTable)) {
            return null;
        }
        if (warp instanceof WarpGrid) {
            if (interpolation instanceof InterpolationTable) {
                return new MlibWarpGridTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, (WarpGrid)warp, interpolation, dArray);
            }
            return new MlibWarpGridOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, (WarpGrid)warp, interpolation, n, dArray);
        }
        if (warp instanceof WarpPolynomial) {
            if (interpolation instanceof InterpolationTable) {
                return new MlibWarpPolynomialTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, (WarpPolynomial)warp, interpolation, dArray);
            }
            return new MlibWarpPolynomialOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, (WarpPolynomial)warp, interpolation, n, dArray);
        }
        return null;
    }
}

