/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBilinearOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    Rational half = new Rational(1L, 2L);
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n2];
                nArray3 = new int[n];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n2];
                fArray = new float[n];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            nArray3[n11] = (int)((float)l8 / (float)l9 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            nArray2[n12] = (n9 - n2) * n4;
            nArray4[n12] = (int)((float)l3 / (float)l4 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n12;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            fArray[n11] = (float)l8 / (float)l9;
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            nArray2[n12] = (n9 - n2) * n4;
            fArray2[n12] = (float)l3 / (float)l4;
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n12;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 + n2;
                int n17 = 0;
                while (n17 < n4) {
                    int n18 = nArray3[n17];
                    int n19 = nArray[n17];
                    int n20 = n19 + n;
                    int n21 = byArray4[n19 + n15] & 0xFF;
                    int n22 = byArray4[n20 + n15] & 0xFF;
                    int n23 = byArray4[n19 + n16] & 0xFF;
                    int n24 = byArray4[n20 + n16] & 0xFF;
                    int n25 = (n22 - n21) * n18 + (n21 << this.subsampleBits);
                    int n26 = (n24 - n23) * n18 + (n23 << this.subsampleBits);
                    int n27 = (n26 - n25) * n14 + (n25 << this.subsampleBits) + this.round2 >> this.shift2;
                    byArray3[n13] = (byte)(n27 & 0xFF);
                    n13 += n7;
                    ++n17;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 + n2;
                int n17 = 0;
                while (n17 < n4) {
                    int n18 = nArray3[n17];
                    int n19 = nArray[n17];
                    int n20 = n19 + n;
                    short s = sArray4[n19 + n15];
                    short s2 = sArray4[n20 + n15];
                    short s3 = sArray4[n19 + n16];
                    short s4 = sArray4[n20 + n16];
                    int n21 = (s2 - s) * n18 + (s << this.subsampleBits);
                    int n22 = (s4 - s3) * n18 + (s3 << this.subsampleBits);
                    int n23 = (n22 - n21) * n14 + (n21 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n13] = (short)n23;
                    n13 += n7;
                    ++n17;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 + n2;
                int n17 = 0;
                while (n17 < n4) {
                    int n18 = nArray3[n17];
                    int n19 = nArray[n17];
                    int n20 = n19 + n;
                    int n21 = sArray4[n19 + n15] & 0xFFFF;
                    int n22 = sArray4[n20 + n15] & 0xFFFF;
                    int n23 = sArray4[n19 + n16] & 0xFFFF;
                    int n24 = sArray4[n20 + n16] & 0xFFFF;
                    int n25 = (n22 - n21) * n18 + (n21 << this.subsampleBits);
                    int n26 = (n24 - n23) * n18 + (n23 << this.subsampleBits);
                    int n27 = (n26 - n25) * n14 + (n25 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n13] = (short)(n27 & 0xFFFF);
                    n13 += n7;
                    ++n17;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 29 - this.subsampleBits;
        int n10 = 0;
        while (n10 < n6) {
            int[] nArray9 = nArray5[n10];
            int[] nArray10 = nArray7[n10];
            int n11 = nArray6[n10];
            int n12 = nArray8[n10];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n11;
                int n15 = nArray4[n13];
                int n16 = nArray2[n13] + n12;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n4) {
                    long l;
                    long l2;
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 + n;
                    int n22 = nArray10[n20 + n16];
                    int n23 = nArray10[n21 + n16];
                    int n24 = nArray10[n20 + n17];
                    int n25 = nArray10[n21 + n17];
                    if ((n22 | n24) >>> n9 == 0) {
                        if ((n23 | n25) >>> n9 == 0) {
                            l2 = (n23 - n22) * n19 + (n22 << this.subsampleBits);
                            l = (n25 - n24) * n19 + (n24 << this.subsampleBits);
                        } else {
                            l2 = ((long)n23 - (long)n22) * (long)n19 + (long)(n22 << this.subsampleBits);
                            l = ((long)n25 - (long)n24) * (long)n19 + (long)(n24 << this.subsampleBits);
                        }
                    } else {
                        l2 = ((long)n23 - (long)n22) * (long)n19 + ((long)n22 << this.subsampleBits);
                        l = ((long)n25 - (long)n24) * (long)n19 + ((long)n24 << this.subsampleBits);
                    }
                    nArray9[n14] = (int)((l - l2) * (long)n15 + (l2 << this.subsampleBits) + (long)this.round2 >> this.shift2);
                    n14 += n7;
                    ++n18;
                }
                n11 += n8;
                ++n13;
            }
            ++n10;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 0;
        while (n9 < n6) {
            float[] fArray5 = fArray3[n9];
            float[] fArray6 = fArray4[n9];
            int n10 = nArray3[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                float f = fArray2[n12];
                int n14 = nArray2[n12] + n11;
                int n15 = n14 + n2;
                int n16 = 0;
                while (n16 < n4) {
                    float f2 = fArray[n16];
                    int n17 = nArray[n16];
                    int n18 = n17 + n;
                    float f3 = fArray6[n17 + n14];
                    float f4 = fArray6[n18 + n14];
                    float f5 = fArray6[n17 + n15];
                    float f6 = fArray6[n18 + n15];
                    float f7 = (f4 - f3) * f2 + f3;
                    float f8 = (f6 - f5) * f2 + f5;
                    fArray5[n13] = (f8 - f7) * f + f7;
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 0;
        while (n9 < n6) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray3[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                double d = fArray2[n12];
                int n14 = nArray2[n12] + n11;
                int n15 = n14 + n2;
                int n16 = 0;
                while (n16 < n4) {
                    double d2 = fArray[n16];
                    int n17 = nArray[n16];
                    int n18 = n17 + n;
                    double d3 = dArray4[n17 + n14];
                    double d4 = dArray4[n18 + n14];
                    double d5 = dArray4[n17 + n15];
                    double d6 = dArray4[n18 + n15];
                    double d7 = (d4 - d3) * d2 + d3;
                    double d8 = (d6 - d5) * d2 + d5;
                    dArray3[n13] = (d8 - d7) * d + d7;
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }
}

